/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.render;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class WCCuboidRenderer
implements ISimpleBlockRenderingHandler {
    public static void renderStandardInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderCrossedSquaresInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147765_a(block.func_149691_a(0, meta), -0.5, -0.5, -0.5, 1.0f);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        WCCuboidBlock cblock = (WCCuboidBlock)block;
        List<WesterosBlockDef.Cuboid> cubs = cblock.getCuboidList(meta);
        if (cubs != null) {
            int cnt = cubs.size();
            for (int i = 0; i < cnt; ++i) {
                WesterosBlockDef.Cuboid cub = cubs.get(i);
                cblock.setActiveRenderCuboid(cub, renderer, meta, i);
                renderer.func_147782_a((double)cub.xMin, (double)cub.yMin, (double)cub.zMin, (double)cub.xMax, (double)cub.yMax, (double)cub.zMax);
                if ("crossed".equals(cub.shape)) {
                    WCCuboidRenderer.renderCrossedSquaresInvBlock(renderer, block, meta);
                    continue;
                }
                WCCuboidRenderer.renderStandardInvBlock(renderer, block, meta);
            }
            cblock.setActiveRenderCuboid(null, renderer, meta, -1);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        WCCuboidBlock cblock = (WCCuboidBlock)block;
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.Cuboid> cubs = cblock.getCuboidList(meta);
        if (cubs != null) {
            int cnt = cubs.size();
            for (int i = 0; i < cnt; ++i) {
                WesterosBlockDef.Cuboid cub = cubs.get(i);
                cblock.setActiveRenderCuboid(cub, renderer, meta, i);
                renderer.func_147782_a((double)cub.xMin, (double)cub.yMin, (double)cub.zMin, (double)cub.xMax, (double)cub.yMax, (double)cub.zMax);
                if ("crossed".equals(cub.shape)) {
                    renderer.func_147746_l((Block)cblock, x, y, z);
                    continue;
                }
                renderer.func_147784_q((Block)cblock, x, y, z);
            }
            cblock.setActiveRenderCuboid(null, renderer, meta, -1);
        }
        return true;
    }

    public int getRenderId() {
        return WesterosBlocks.cuboidRenderID;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

