/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.render;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.render.WCCuboidRenderer;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class WCCuboidNSEWUDRenderer
implements ISimpleBlockRenderingHandler {
    private float red;
    private float green;
    private float blue;
    private static final int[][][] sideToCorner = new int[][][]{new int[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}}, new int[][]{{0, 1, 0}, {0, 1, 1}, {1, 1, 1}, {1, 1, 0}}, new int[][]{{1, 1, 0}, {1, 0, 0}, {0, 0, 0}, {0, 1, 0}}, new int[][]{{0, 1, 1}, {0, 0, 1}, {1, 0, 1}, {1, 1, 1}}, new int[][]{{0, 1, 0}, {0, 0, 0}, {0, 0, 1}, {0, 1, 1}}, new int[][]{{1, 1, 1}, {1, 0, 1}, {1, 0, 0}, {1, 1, 0}}};
    private static final CalcUV[][][] uvCalc = new CalcUV[][][]{{{CalcUV.XMIN, CalcUV.INV_ZMAX}, {CalcUV.INV_ZMAX, CalcUV.INV_XMAX}, {CalcUV.INV_XMAX, CalcUV.ZMIN}, {CalcUV.ZMIN, CalcUV.XMIN}}, {{CalcUV.XMIN, CalcUV.ZMIN}, {CalcUV.ZMIN, CalcUV.INV_XMAX}, {CalcUV.INV_XMAX, CalcUV.INV_ZMAX}, {CalcUV.INV_ZMAX, CalcUV.XMIN}}, {{CalcUV.INV_XMAX, CalcUV.INV_YMAX}, {CalcUV.INV_YMAX, CalcUV.XMIN}, {CalcUV.XMIN, CalcUV.YMIN}, {CalcUV.YMIN, CalcUV.INV_XMAX}}, {{CalcUV.XMIN, CalcUV.INV_YMAX}, {CalcUV.INV_YMAX, CalcUV.INV_XMAX}, {CalcUV.INV_XMAX, CalcUV.YMIN}, {CalcUV.YMIN, CalcUV.XMIN}}, {{CalcUV.ZMIN, CalcUV.INV_YMAX}, {CalcUV.INV_YMAX, CalcUV.INV_ZMAX}, {CalcUV.INV_ZMAX, CalcUV.YMIN}, {CalcUV.YMIN, CalcUV.ZMIN}}, {{CalcUV.INV_ZMAX, CalcUV.INV_YMAX}, {CalcUV.INV_YMAX, CalcUV.ZMIN}, {CalcUV.ZMIN, CalcUV.YMIN}, {CalcUV.YMIN, CalcUV.INV_ZMAX}}};
    private static final float[] sidebright = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    private double[] xr = new double[2];
    private double[] yr = new double[2];
    private double[] zr = new double[2];

    public static void renderStandardInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderCrossedSquaresInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147765_a(block.func_149691_a(0, meta), -0.5, -0.5, -0.5, 1.0f);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        WCCuboidBlock cblock = (WCCuboidBlock)block;
        List<WesterosBlockDef.Cuboid> cubs = cblock.getCuboidList(meta);
        if (cubs != null) {
            int cnt = cubs.size();
            for (int i = 0; i < cnt; ++i) {
                WesterosBlockDef.Cuboid cub = cubs.get(i);
                cblock.setActiveRenderCuboid(cub, renderer, meta, i);
                renderer.func_147782_a((double)cub.xMin, (double)cub.yMin, (double)cub.zMin, (double)cub.xMax, (double)cub.yMax, (double)cub.zMax);
                if ("crossed".equals(cub.shape)) {
                    WCCuboidRenderer.renderCrossedSquaresInvBlock(renderer, block, meta);
                    continue;
                }
                WCCuboidRenderer.renderStandardInvBlock(renderer, block, meta);
            }
            cblock.setActiveRenderCuboid(null, renderer, meta, -1);
        }
    }

    private void prepLighting(IBlockAccess world, Block block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        int mult = block.func_149720_d(world, x, y, z);
        this.red = (float)(mult >> 16 & 0xFF) / 255.0f;
        this.green = (float)(mult >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(mult & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float nred = (this.red * 30.0f + this.green * 59.0f + this.blue * 11.0f) / 100.0f;
            float ngreen = (this.red * 30.0f + this.green * 70.0f) / 100.0f;
            float nblue = (this.red * 30.0f + this.green * 70.0f) / 100.0f;
            this.red = nred;
            this.green = ngreen;
            this.blue = nblue;
        }
    }

    private double calcInterpUV(IIcon ico, CalcUV f, WesterosBlockDef.Cuboid cub, boolean get_v, boolean min) {
        double v = 0.0;
        switch (f) {
            case XMIN: {
                if (min) {
                    v = 16.0 * (double)cub.xMin;
                    break;
                }
                v = 16.0 * (double)cub.xMax;
                break;
            }
            case YMIN: {
                if (min) {
                    v = 16.0 * (double)cub.yMin;
                    break;
                }
                v = 16.0 * (double)cub.yMax;
                break;
            }
            case ZMIN: {
                if (min) {
                    v = 16.0 * (double)cub.zMin;
                    break;
                }
                v = 16.0 * (double)cub.zMax;
                break;
            }
            case INV_XMAX: {
                if (min) {
                    v = 16.0 * (1.0 - (double)cub.xMax);
                    break;
                }
                v = 16.0 * (1.0 - (double)cub.xMin);
                break;
            }
            case INV_YMAX: {
                if (min) {
                    v = 16.0 * (1.0 - (double)cub.yMax);
                    break;
                }
                v = 16.0 * (1.0 - (double)cub.yMin);
                break;
            }
            case INV_ZMAX: {
                v = min ? 16.0 * (1.0 - (double)cub.zMax) : 16.0 * (1.0 - (double)cub.zMin);
            }
        }
        if (get_v) {
            return ico.func_94207_b(v);
        }
        return ico.func_94214_a(v);
    }

    private double calcMinU(IIcon ico, int side, int rot, WesterosBlockDef.Cuboid cub) {
        return this.calcInterpUV(ico, uvCalc[side][rot][0], cub, false, true);
    }

    private double calcMaxU(IIcon ico, int side, int rot, WesterosBlockDef.Cuboid cub) {
        return this.calcInterpUV(ico, uvCalc[side][rot][0], cub, false, false);
    }

    private double calcMinV(IIcon ico, int side, int rot, WesterosBlockDef.Cuboid cub) {
        return this.calcInterpUV(ico, uvCalc[side][rot][1], cub, true, true);
    }

    private double calcMaxV(IIcon ico, int side, int rot, WesterosBlockDef.Cuboid cub) {
        return this.calcInterpUV(ico, uvCalc[side][rot][1], cub, true, false);
    }

    private void renderCuboidSide(WCCuboidBlock block, WesterosBlockDef.Cuboid cub, RenderBlocks renderer, int meta, int side) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = renderer.func_147787_a((Block)block, side, meta);
        int rot = cub.sideRotations[side] / 90;
        double umin = this.calcMinU(icon, side, rot, cub);
        double umax = this.calcMaxU(icon, side, rot, cub);
        double vmin = this.calcMinV(icon, side, rot, cub);
        double vmax = this.calcMaxV(icon, side, rot, cub);
        tessellator.func_78386_a(this.red * sidebright[side], this.green * sidebright[side], this.blue * sidebright[side]);
        int[][] c = sideToCorner[side];
        tessellator.func_78374_a(this.xr[c[(4 - rot) % 4][0]], this.yr[c[(4 - rot) % 4][1]], this.zr[c[(4 - rot) % 4][2]], umin, vmin);
        tessellator.func_78374_a(this.xr[c[(5 - rot) % 4][0]], this.yr[c[(5 - rot) % 4][1]], this.zr[c[(5 - rot) % 4][2]], umin, vmax);
        tessellator.func_78374_a(this.xr[c[(6 - rot) % 4][0]], this.yr[c[(6 - rot) % 4][1]], this.zr[c[(6 - rot) % 4][2]], umax, vmax);
        tessellator.func_78374_a(this.xr[c[(7 - rot) % 4][0]], this.yr[c[(7 - rot) % 4][1]], this.zr[c[(7 - rot) % 4][2]], umax, vmin);
    }

    private void renderCuboid(WCCuboidBlock block, WesterosBlockDef.Cuboid cub, RenderBlocks renderer, int meta, int x, int y, int z) {
        this.xr[0] = (float)x + cub.xMin;
        this.xr[1] = (float)x + cub.xMax;
        this.yr[0] = (float)y + cub.yMin;
        this.yr[1] = (float)y + cub.yMax;
        this.zr[0] = (float)z + cub.zMin;
        this.zr[1] = (float)z + cub.zMax;
        for (int side = 0; side < 6; ++side) {
            this.renderCuboidSide(block, cub, renderer, meta, side);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        WCCuboidBlock cblock = (WCCuboidBlock)block;
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.Cuboid> cubs = cblock.getCuboidList(meta);
        if (cubs != null) {
            this.prepLighting(world, block, x, y, z);
            int cnt = cubs.size();
            for (int i = 0; i < cnt; ++i) {
                WesterosBlockDef.Cuboid cub = cubs.get(i);
                cblock.setActiveRenderCuboid(cub, renderer, meta, i);
                renderer.func_147782_a((double)cub.xMin, (double)cub.yMin, (double)cub.zMin, (double)cub.xMax, (double)cub.yMax, (double)cub.zMax);
                if ("crossed".equals(cub.shape)) {
                    renderer.func_147746_l((Block)cblock, x, y, z);
                    continue;
                }
                this.renderCuboid(cblock, cub, renderer, meta, x, y, z);
            }
            cblock.setActiveRenderCuboid(null, renderer, meta, -1);
        }
        return true;
    }

    public int getRenderId() {
        return WesterosBlocks.cuboidNSEWUDRenderID;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    private static enum CalcUV {
        XMIN,
        YMIN,
        ZMIN,
        INV_XMAX,
        INV_YMAX,
        INV_ZMAX;

    }
}

