/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.network;

import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.network.BlockMsgPacket;
import com.westeroscraft.westerosblocks.network.WBPacket;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;

public class WesterosBlocksChannelHandler
extends FMLIndexedMessageToMessageCodec<WBPacket> {
    public static final String CHANNEL = "WesterosBlocks";
    public static final byte BLOCKMSG = 0;

    public WesterosBlocksChannelHandler() {
        this.addDiscriminator(0, BlockMsgPacket.class);
    }

    public void encodeInto(ChannelHandlerContext ctx, WBPacket packet, ByteBuf data) throws Exception {
        packet.writeData(data);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data, WBPacket packet) {
        packet.readData(data);
    }

    public static void sendBlockMessage(Block blk, EntityPlayerMP player, byte msgid, byte[] data) {
        byte[] blkmsg = new byte[1 + data.length];
        blkmsg[0] = msgid;
        System.arraycopy(data, 0, blkmsg, 1, data.length);
        int blkid = Block.func_149682_b((Block)blk);
        BlockMsgPacket pkt = new BlockMsgPacket(blkid, blkmsg);
        WesterosBlocksChannelHandler.sendToPlayer(pkt, player);
        System.out.println("sendBlockMessge(" + blkid + ", " + player.getDisplayName() + "," + msgid);
    }

    public static void sendToPlayer(WBPacket packet, EntityPlayerMP player) {
        try {
            WesterosBlocks.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            WesterosBlocks.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            WesterosBlocks.channels.get(Side.SERVER).writeOutbound(new Object[]{packet});
        }
        catch (Throwable t) {
            String name = player.getDisplayName();
            if (name == null) {
                name = "<no name>";
            }
            WesterosBlocks.log.warning("sentToPlayer \"" + name + "\" error: " + t.getMessage());
        }
    }
}

