/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCSolidBlock;
import com.westeroscraft.westerosblocks.tileentity.WCTileEntitySound;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class WCSoundBlock
extends WCSolidBlock
implements ITileEntityProvider {
    public int[] def_period_by_meta = new int[16];
    public int[] def_addition_by_meta = new int[16];
    public int[] def_starttime_by_meta = new int[16];
    public int[] def_endtime_by_meta = new int[16];

    protected WCSoundBlock(WesterosBlockDef def) {
        super(def);
        for (int i = 0; i < 16; ++i) {
            String[] toks;
            String type = def.getType(i);
            if (type == null) continue;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2) continue;
                if (flds[0].equals("period")) {
                    this.def_period_by_meta[i] = (int)Math.round(20.0 * Double.parseDouble(flds[1]));
                    continue;
                }
                if (flds[0].equals("random-add")) {
                    this.def_addition_by_meta[i] = (int)Math.round(20.0 * Double.parseDouble(flds[1]));
                    continue;
                }
                if (flds[0].equals("start-time")) {
                    this.def_starttime_by_meta[i] = (Integer.parseInt(flds[1]) * 10 + 18000) % 24000;
                    continue;
                }
                if (flds[0].equals("end-time")) {
                    this.def_endtime_by_meta[i] = (Integer.parseInt(flds[1]) * 10 + 18000) % 24000;
                    continue;
                }
                WesterosBlocks.log.warning("Invalid type attribute '" + flds[0] + "' in " + def.blockName + "[" + i + "]");
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        boolean flag = world.func_72864_z(x, y, z);
        WCTileEntitySound tileentity = (WCTileEntitySound)world.func_147438_o(x, y, z);
        if (tileentity != null && tileentity.previousRedstoneState != flag) {
            if (flag) {
                tileentity.triggerSound(this, world, x, y, z);
            }
            tileentity.previousRedstoneState = flag;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        WCTileEntitySound tileentity = (WCTileEntitySound)world.func_147438_o(x, y, z);
        if (tileentity != null) {
            tileentity.changeSoundSelection(this, world.func_72805_g(x, y, z));
            tileentity.triggerSound(this, world, x, y, z);
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        WCTileEntitySound tileentity;
        if (!world.field_72995_K && (tileentity = (WCTileEntitySound)world.func_147438_o(x, y, z)) != null) {
            tileentity.triggerSound(this, world, x, y, z);
        }
    }

    public TileEntity func_149915_a(World par1World, int xxx) {
        return new WCTileEntitySound();
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParm) {
        if (eventID != 0) {
            return true;
        }
        int soundIndex = eventParm;
        int meta = world.func_72805_g(x, y, z);
        List<String> sndids = this.getWBDefinition().getSoundIDList(meta);
        String sndid = null;
        if (sndids != null && sndids.size() > soundIndex) {
            sndid = sndids.get(soundIndex);
        }
        if (sndid != null) {
            int cidx = sndid.indexOf(58);
            if (cidx < 0) {
                sndid = "westerosblocks:" + sndid;
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sndid, 1.0f, 1.0f);
        }
        return true;
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            GameRegistry.registerTileEntity(WCTileEntitySound.class, (String)def.blockName);
            return new Block[]{new WCSoundBlock(def)};
        }
    }
}

