/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCSolidBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    private boolean isSolidOpaque = true;

    protected WCSolidBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.isSolidOpaque = !def.nonOpaque;
        this.def = def;
        def.doStandardContructorSettings(this);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.def.doStandardIconGet(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity(this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    public boolean func_149662_c() {
        return this.isSolidOpaque;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd, 0, this.def.alphaRender ? TransparencyMode.TRANSPARENT : TransparencyMode.OPAQUE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd);
        super.func_149734_b(world, x, y, z, rnd);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        if (!this.def.hasCollisionBoxes()) {
            super.func_149743_a(world, x, y, z, mask, list, entity);
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.BoundingBox> cl = this.def.getCollisionBoxList(meta);
        if (cl == null) {
            super.func_149743_a(world, x, y, z, mask, list, entity);
            return;
        }
        for (WesterosBlockDef.BoundingBox c : cl) {
            this.func_149676_a(c.xMin, c.yMin, c.zMin, c.xMax, c.yMax, c.zMax);
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        this.def.setBlockBoundsBasedOnState(this, (IBlockAccess)world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        if (!this.def.hasCollisionBoxes()) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.BoundingBox> cl = this.def.getCollisionBoxList(meta);
        if (cl == null) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
        MovingObjectPosition bestpos = null;
        double bestdist = 0.0;
        for (WesterosBlockDef.BoundingBox c : cl) {
            this.func_149676_a(c.xMin, c.yMin, c.zMin, c.xMax, c.yMax, c.zMax);
            MovingObjectPosition pos = super.func_149731_a(world, x, y, z, start, end);
            if (pos == null) continue;
            if (bestpos == null) {
                bestpos = pos;
                bestdist = bestpos.field_72307_f.func_72436_e(end);
                continue;
            }
            double dist = pos.field_72307_f.func_72436_e(end);
            if (!(dist > bestdist)) continue;
            bestpos = pos;
            bestdist = dist;
        }
        this.def.setBlockBoundsBasedOnState(this, (IBlockAccess)world, x, y, z);
        return bestpos;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            return new Block[]{new WCSolidBlock(def)};
        }
    }
}

