/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.WCSlabItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.BoxBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCSlabBlock
extends BlockSlab
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private static final int HALF_IDX = 0;
    private static final int FULL_IDX = 1;
    private WesterosBlockDef def;
    private WCSlabBlock otherBlock;
    private static BitSet halfSlabs = new BitSet();

    protected WCSlabBlock(WesterosBlockDef def, boolean is_double) {
        super(is_double, def.getMaterial());
        this.def = def;
        if (def.lightOpacity == -999) {
            def.lightOpacity = 255;
        }
        def.doStandardContructorSettings((Block)this, is_double ? 1 : 0);
        if (is_double) {
            this.func_149647_a(null);
        } else {
            this.field_149783_u = true;
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        if (this.field_150004_a) {
            WCSlabItem.setSlabs(this.otherBlock, this);
            this.def.doStandardRegisterActions((Block)this, WCSlabItem.class, 1);
        } else {
            WCSlabItem.setSlabs(this, this.otherBlock);
            this.def.doStandardRegisterActions((Block)this, WCSlabItem.class, 0);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.def.doStandardIconGet(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks((Block)this, Item.func_150891_b((Item)itm), tab, list);
    }

    public String func_150002_b(int meta) {
        return this.def.getBlockName(1) + "." + meta;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity((Block)this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        if (!this.field_150004_a) {
            return Item.func_150898_a((Block)this);
        }
        return Item.func_150898_a((Block)this.otherBlock);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack(Item.func_150898_a((Block)this), 2, meta & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd);
        super.func_149734_b(world, x, y, z, rnd);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        boolean flag;
        if (this.field_150004_a) {
            return super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
        }
        if (par5 != 1 && par5 != 0 && !super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5)) {
            return false;
        }
        int i1 = par2 + Facing.field_71586_b[Facing.field_71588_a[par5]];
        int j1 = par3 + Facing.field_71587_c[Facing.field_71588_a[par5]];
        int k1 = par4 + Facing.field_71585_d[Facing.field_71588_a[par5]];
        boolean bl = flag = (par1IBlockAccess.func_72805_g(i1, j1, k1) & 8) != 0;
        return flag ? (par5 == 0 ? true : (par5 == 1 && super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5) ? true : !WCSlabBlock.isBlockSingleSlab(par1IBlockAccess.func_147439_a(par2, par3, par4)) || (par1IBlockAccess.func_72805_g(par2, par3, par4) & 8) == 0)) : (par5 == 1 ? true : (par5 == 0 && super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5) ? true : !WCSlabBlock.isBlockSingleSlab(par1IBlockAccess.func_147439_a(par2, par3, par4)) || (par1IBlockAccess.func_72805_g(par2, par3, par4) & 8) != 0));
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isBlockSingleSlab(Block id) {
        return id == Blocks.field_150333_U || id == Blocks.field_150376_bx || halfSlabs.get(Block.func_149682_b((Block)id));
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        this.def.defaultRegisterTextures(mtd);
        if (!this.field_150004_a) {
            String blkname = this.def.getBlockName(0);
            this.def.defaultRegisterTextureBlock(mtd, 0, TransparencyMode.SEMITRANSPARENT);
            BoxBlockModel bottom = md.addBoxModel(blkname);
            bottom.setYRange(0.0, 0.5);
            BoxBlockModel top = md.addBoxModel(blkname);
            top.setYRange(0.5, 1.0);
            for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
                bottom.setMetaValue(sb.meta);
                top.setMetaValue(sb.meta | 8);
            }
        } else {
            this.def.defaultRegisterTextureBlock(mtd, 1, null);
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, null)) {
                return null;
            }
            def.setBlockIDCount(2);
            WCSlabBlock half = new WCSlabBlock(def, false);
            WCSlabBlock full = new WCSlabBlock(def, true);
            half.otherBlock = full;
            full.otherBlock = half;
            return new Block[]{half, full};
        }
    }
}

