/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCLeavesBlock
extends BlockLeavesBase
implements IShearable,
WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    private int[] adjacentTreeBlocks;
    private boolean[] nodecay;

    protected WCLeavesBlock(WesterosBlockDef def) {
        super(def.getMaterial(), false);
        this.func_149675_a(true);
        this.def = def;
        if (def.lightOpacity == -999) {
            def.lightOpacity = 1;
        }
        def.doStandardContructorSettings((Block)this);
        this.nodecay = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            String typ = def.getType(i);
            if (typ == null || !typ.contains("no-decay")) continue;
            this.nodecay[i] = true;
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.def.doStandardIconGet((side > 1 ? 0 : 1) | (Blocks.field_150362_t.func_149662_c() ? 0 : 2), meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks((Block)this, Item.func_150891_b((Item)itm), tab, list);
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity((Block)this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        this.def.doRandomDisplayTick(world, x, y, z, random);
        super.func_149734_b(world, x, y, z, random);
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int p_149749_6_) {
        int b0 = 1;
        int i1 = b0 + 1;
        if (world.func_72904_c(x - i1, y - i1, z - i1, x + i1, y + i1, z + i1)) {
            for (int j1 = -b0; j1 <= b0; ++j1) {
                for (int k1 = -b0; k1 <= b0; ++k1) {
                    for (int l1 = -b0; l1 <= b0; ++l1) {
                        Block block = world.func_147439_a(x + j1, y + k1, z + l1);
                        if (!block.isLeaves((IBlockAccess)world, x + j1, y + k1, z + l1)) continue;
                        block.beginLeavesDecay(world, x + j1, y + k1, z + l1);
                    }
                }
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (this.nodecay[meta & 7]) {
            return;
        }
        if ((meta & 8) != 0) {
            int l1;
            int b0 = 4;
            int i1 = b0 + 1;
            int b1 = 32;
            int j1 = b1 * b1;
            int k1 = b1 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[b1 * b1 * b1];
            }
            if (world.func_72904_c(x - i1, y - i1, z - i1, x + i1, y + i1, z + i1)) {
                int j2;
                int i2;
                for (l1 = -b0; l1 <= b0; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            Block block = world.func_147439_a(x + l1, y + i2, z + j2);
                            this.adjacentTreeBlocks[(l1 + k1) * j1 + (i2 + k1) * b1 + j2 + k1] = block != null && block.canSustainLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? 0 : (block != null && block.isLeaves((IBlockAccess)world, x + l1, y + i2, z + j2) ? -2 : -1);
                        }
                    }
                }
                for (l1 = 1; l1 <= 4; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            for (int k2 = -b0; k2 <= b0; ++k2) {
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1] != l1 - 1) continue;
                                if (this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] = l1;
                            }
                        }
                    }
                }
            }
            if ((l1 = this.adjacentTreeBlocks[k1 * j1 + k1 * b1 + k1]) >= 0) {
                world.func_72921_c(x, y, z, meta & 7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z) & 7, 0);
        world.func_147468_f(x, y, z);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 7));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 4);
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        String blkname = this.def.getBlockName(0);
        for (int meta = 0; meta < 8; ++meta) {
            WesterosBlockDef.Subblock sb = this.def.getByMeta(meta);
            if (sb == null) continue;
            String topbot = sb.getTextureByIndex(2);
            String sides = sb.getTextureByIndex(3);
            BlockTextureRecord btr = mtd.addBlockTextureRecord(blkname);
            btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
            btr.setMetaValue(meta);
            btr.setMetaValue(meta | 8);
            btr.setSideTexture(topbot, BlockSide.TOP);
            btr.setSideTexture(topbot, BlockSide.BOTTOM);
            btr.setSideTexture(sides, BlockSide.ALLSIDES);
            this.def.setBlockColorMap(btr, sb);
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, null)) {
                return null;
            }
            return new Block[]{new WCLeavesBlock(def)};
        }
    }
}

