/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.items.WCLayerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.BoxBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TransparencyMode;

public class WCLayerBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    public int layerCount;

    protected WCLayerBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings(this);
        this.layerCount = 8;
        int off = def.type.indexOf("cnt:");
        if (off >= 0) {
            try {
                this.layerCount = Integer.parseInt(def.type.substring(off + 4));
            }
            catch (NumberFormatException nfx) {
                WesterosBlocks.log.info("Error parsing 'cnt:' in " + def.blockName);
            }
        }
        if (this.layerCount < 2) {
            this.layerCount = 2;
        }
        if (this.layerCount > 16) {
            this.layerCount = 16;
        }
        this.setBlockBoundsForLayerDepth(0);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        WCLayerItem.block = this;
        this.def.doStandardRegisterActions(this, WCLayerItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.def.doStandardIconGet(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        int l = 1 + par1World.func_72805_g(par2, par3, par4) % this.layerCount;
        float f = 1.0f / (float)this.layerCount;
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((float)par3 + (float)l * f), (double)((double)par4 + this.field_149757_G));
    }

    public void func_149719_a(IBlockAccess blockaccess, int x, int y, int z) {
        this.setBlockBoundsForLayerDepth(blockaccess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        return side == 1 ? true : super.func_149646_a(access, x, y, z, side);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity(this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    private void setBlockBoundsForLayerDepth(int meta) {
        int j = meta % this.layerCount;
        float f = (float)(1 + j) / (float)this.layerCount;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == null) {
            return false;
        }
        if (block == this) {
            return true;
        }
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) {
            return true;
        }
        if (!block.isLeaves((IBlockAccess)world, x, y - 1, z) && !block.func_149662_c()) {
            return false;
        }
        boolean rslt = block.func_149688_o().func_76230_c();
        return rslt;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        this.canLayerStay(par1World, par2, par3, par4);
    }

    private boolean canLayerStay(World par1World, int par2, int par3, int par4) {
        if (!this.func_149742_c(par1World, par2, par3, par4)) {
            par1World.func_147468_f(par2, par3, par4);
            return false;
        }
        return true;
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        super.func_149636_a(par1World, par2EntityPlayer, par3, par4, par5, par6);
        par1World.func_147468_f(par3, par4, par5);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta % this.layerCount + 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd);
        super.func_149734_b(world, x, y, z, rnd);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd, 0, TransparencyMode.TRANSPARENT);
        for (int i = 0; i < this.layerCount; ++i) {
            BoxBlockModel mod = md.addBoxModel(blkname);
            mod.setYRange(0.0, (double)(i + 1) / (double)this.layerCount);
            mod.setMetaValue(i);
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCLayerBlock(def)};
        }
    }
}

