/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.renderer.RenderPatchFactory;

public class WCLadderBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;

    protected WCLadderBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings(this);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.updateLadderBounds(par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public void updateLadderBounds(int meta) {
        float f = 0.125f;
        switch (meta >> 2) {
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                break;
            }
            case 1: {
                this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 0: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return WesterosBlocks.ladderRenderID;
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH);
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int meta) {
        int j1 = meta & 3;
        if ((j1 == 0 || par5 == 2) && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH)) {
            j1 |= 0xC;
        }
        if ((j1 == 0 || par5 == 3) && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
            j1 |= 8;
        }
        if ((j1 == 0 || par5 == 4) && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST)) {
            j1 |= 4;
        }
        if ((j1 == 0 || par5 == 5) && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST)) {
            j1 |= 0;
        }
        return j1;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        boolean flag = false;
        int sidemeta = meta >> 2;
        if (sidemeta == 3 && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH)) {
            flag = true;
        }
        if (sidemeta == 2 && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
            flag = true;
        }
        if (sidemeta == 1 && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST)) {
            flag = true;
        }
        if (sidemeta == 0 && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST)) {
            flag = true;
        }
        if (!flag) {
            this.func_149697_b(par1World, par2, par3, par4, meta & 3, 0);
            par1World.func_147468_f(par2, par3, par4);
        }
        super.func_149695_a(par1World, par2, par3, par4, par5);
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.def.doStandardIconGet(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    public int func_149692_a(int meta) {
        return meta & 3;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity(this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.values()[side];
        int meta = access.func_72805_g(x - dir.offsetX, y, z - dir.offsetZ);
        switch (meta >> 2 & 3) {
            case 0: 
            case 1: {
                return side == 4 || side == 5;
            }
        }
        return side == 2 || side == 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd);
        super.func_149734_b(world, x, y, z, rnd);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        this.def.registerPatchTextureBlock(mtd, 1);
        PatchBlockModel mod = md.addPatchModel(blkname);
        String patch0 = mod.addPatch(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTH);
        PatchBlockModel mod90 = md.addPatchModel(blkname);
        mod90.addRotatedPatch(patch0, 0, 90, 0);
        PatchBlockModel mod180 = md.addPatchModel(blkname);
        mod180.addRotatedPatch(patch0, 0, 180, 0);
        PatchBlockModel mod270 = md.addPatchModel(blkname);
        mod270.addRotatedPatch(patch0, 0, 270, 0);
        for (WesterosBlockDef.Subblock sb : this.def.subBlocks) {
            mod.setMetaValue(sb.meta);
            mod90.setMetaValue(sb.meta + 8);
            mod180.setMetaValue(sb.meta + 4);
            mod270.setMetaValue(sb.meta + 12);
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(3);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCLadderBlock(def)};
        }
    }
}

