/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.items.WCHalfDoorItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.TextureModifier;
import org.dynmap.modsupport.TransparencyMode;

public class WCHalfDoorBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    private WesterosBlockDef def;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private boolean locked = false;

    protected WCHalfDoorBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings(this);
        String type = def.getType(0);
        if (type != null) {
            String[] toks;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2 || !flds[0].equals("locked")) continue;
                this.locked = flds[1].equals("true");
            }
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCHalfDoorItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
        this.icons = new IIcon[2];
        this.icons[0] = this.def.doStandardIconGet(0, 0);
        this.icons[1] = new IconFlipped(this.icons[0], true, false);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[0];
    }

    private int getIconIndex(int meta, int side) {
        boolean flag1 = false;
        if (side != 1 && side != 0) {
            boolean flag;
            int direction = meta & 3;
            boolean bl = flag = (meta & 4) != 0;
            if (flag) {
                if (direction == 0 && side == 2) {
                    flag1 = !flag1;
                } else if (direction == 1 && side == 5) {
                    flag1 = !flag1;
                } else if (direction == 2 && side == 3) {
                    flag1 = !flag1;
                } else if (direction == 3 && side == 4) {
                    flag1 = !flag1;
                }
            } else {
                if (direction == 0 && side == 5) {
                    flag1 = !flag1;
                } else if (direction == 1 && side == 3) {
                    flag1 = !flag1;
                } else if (direction == 2 && side == 4) {
                    flag1 = !flag1;
                } else if (direction == 3 && side == 2) {
                    boolean bl2 = flag1 = !flag1;
                }
                if ((meta & 8) != 0) {
                    flag1 = !flag1;
                }
            }
        }
        return flag1 ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blkAccess, int x, int y, int z, int side) {
        if (side != 1 && side != 0) {
            return this.icons[this.getIconIndex(blkAccess.func_72805_g(x, y, z), side)];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity(this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        return (l & 4) != 0;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return WesterosBlocks.halfdoorRenderID;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149633_g(par1World, par2, par3, par4);
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149668_a(par1World, par2, par3, par4);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.setDoorRotation(par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public int getDoorOrientation(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.func_72805_g(par2, par3, par4) & 3;
    }

    public boolean isDoorOpen(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return (par1IBlockAccess.func_72805_g(par2, par3, par4) & 4) != 0;
    }

    private void setDoorRotation(int par1) {
        boolean flag1;
        float f = 0.1875f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        int j = par1 & 3;
        boolean flag = (par1 & 4) != 0;
        boolean bl = flag1 = (par1 & 8) != 0;
        if (j == 0) {
            if (flag) {
                if (!flag1) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
            }
        } else if (j == 1) {
            if (flag) {
                if (!flag1) {
                    this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
            }
        } else if (j == 2) {
            if (flag) {
                if (!flag1) {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                }
            } else {
                this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (j == 3) {
            if (flag) {
                if (!flag1) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                } else {
                    this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (this.locked) {
            return false;
        }
        int meta = par1World.func_72805_g(par2, par3, par4);
        par1World.func_72921_c(par2, par3, par4, meta ^= 4, 2);
        par1World.func_147458_c(par2, par3, par4, par2, par3, par4);
        par1World.func_72889_a(par5EntityPlayer, 1003, par2, par3, par4, 0);
        return true;
    }

    private void onPoweredBlockChange(World par1World, int par2, int par3, int par4, boolean par5) {
        boolean flag1;
        int meta = par1World.func_72805_g(par2, par3, par4);
        boolean bl = flag1 = (meta & 4) != 0;
        if (flag1 != par5) {
            par1World.func_72921_c(par2, par3, par4, meta ^= 4, 2);
            par1World.func_147458_c(par2, par3, par4, par2, par3, par4);
            par1World.func_72889_a((EntityPlayer)null, 1003, par2, par3, par4, 0);
        }
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        boolean flag1 = par1World.func_72864_z(par2, par3, par4);
        if ((flag1 || par5.func_149744_f()) && par5 != this) {
            this.onPoweredBlockChange(par1World, par2, par3, par4, flag1);
        }
    }

    public MovingObjectPosition func_149731_a(World par1World, int par2, int par3, int par4, Vec3 par5Vec3, Vec3 par6Vec3) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        return super.func_149731_a(par1World, par2, par3, par4, par5Vec3, par6Vec3);
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return par3 >= par1World.func_72800_K() ? false : World.func_147466_a((IBlockAccess)par1World, (int)par2, (int)(par3 - 1), (int)par4) && super.func_149742_c(par1World, par2, par3, par4);
    }

    public int func_149656_h() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd);
        super.func_149734_b(world, x, y, z, rnd);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        String blkname = this.def.getBlockName(0);
        this.def.defaultRegisterTextures(mtd);
        WesterosBlockDef.Subblock sb = this.def.getByMeta(0);
        if (sb == null || sb.textures == null || sb.textures.size() == 0) {
            return;
        }
        String txt = sb.textures.get(0);
        BlockTextureRecord btr = mtd.addBlockTextureRecord(blkname);
        btr.setTransparencyMode(TransparencyMode.TRANSPARENT);
        btr.setPatchTexture(txt, TextureModifier.NONE, 0);
        btr.setPatchTexture(txt, TextureModifier.FLIPHORIZ, 1);
        this.def.setBlockColorMap(btr, sb);
        block6: for (int meta = 0; meta < 16; ++meta) {
            CuboidBlockModel mod = md.addCuboidModel(blkname);
            mod.setMetaValue(meta);
            int[] txtids = new int[]{this.getIconIndex(meta, 0), this.getIconIndex(meta, 1), this.getIconIndex(meta, 2), this.getIconIndex(meta, 3), this.getIconIndex(meta, 4), this.getIconIndex(meta, 5)};
            switch (meta) {
                case 0: 
                case 7: 
                case 8: 
                case 13: {
                    mod.addCuboid(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0, txtids);
                    continue block6;
                }
                case 1: 
                case 4: 
                case 9: 
                case 14: {
                    mod.addCuboid(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875, txtids);
                    continue block6;
                }
                case 3: 
                case 6: 
                case 11: 
                case 12: {
                    mod.addCuboid(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0, txtids);
                    continue block6;
                }
                case 2: 
                case 5: 
                case 10: 
                case 15: {
                    mod.addCuboid(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0, txtids);
                }
            }
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(0);
            if (!def.validateMetaValues(new int[]{0}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCHalfDoorBlock(def)};
        }
    }
}

