/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import com.westeroscraft.westerosblocks.network.WesterosBlocksChannelHandler;
import com.westeroscraft.westerosblocks.network.WesterosBlocksMessageDest;
import com.westeroscraft.westerosblocks.tileentity.WCFurnaceTileEntity;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.ModTextureDefinition;

public class WCFurnaceBlock
extends BlockFurnace
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport,
WesterosBlocksMessageDest {
    private WesterosBlockDef def;
    private boolean[] alwaysOn = new boolean[2];
    private static final byte MSG_OPENWINDOW = 0;

    protected WCFurnaceBlock(WesterosBlockDef def) {
        super(false);
        this.def = def;
        def.doStandardContructorSettings((Block)this);
        for (int i = 0; i < 2; ++i) {
            String[] toks;
            String type = def.getType(i);
            if (type == null) continue;
            for (String tok : toks = type.split(",")) {
                String[] flds = tok.split(":");
                if (flds.length < 2 || !flds[0].equals("always-on")) continue;
                this.alwaysOn[i] = flds[1].equals("true");
            }
        }
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions((Block)this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions((Block)this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            Block zn_id = world.func_147439_a(x, y, z - 1);
            Block zp_id = world.func_147439_a(x, y, z + 1);
            Block xn_id = world.func_147439_a(x - 1, y, z);
            Block xp_id = world.func_147439_a(x + 1, y, z);
            int dir = 1;
            if (zn_id.func_149730_j() && !zp_id.func_149730_j()) {
                dir = 1;
            }
            if (zp_id.func_149730_j() && !zn_id.func_149730_j()) {
                dir = 0;
            }
            if (xn_id.func_149730_j() && !xp_id.func_149730_j()) {
                dir = 3;
            }
            if (xp_id.func_149730_j() && !xn_id.func_149730_j()) {
                dir = 2;
            }
            world.func_72921_c(x, y, z, dir << 1 | meta & 1, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int metaside = (meta >> 1 & 3) + 2;
        int idx = side < 2 ? side : (metaside != side ? 2 : ((meta & 8) != 0 ? 3 : 4));
        return this.def.doStandardIconGet(idx, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks((Block)this, Item.func_150891_b((Item)itm), tab, list);
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        boolean active;
        int meta = world.func_72805_g(x, y, z);
        boolean bl = active = this.alwaysOn[meta & 1] || (meta & 8) != 0;
        if (active) {
            return this.def.getLightValue(world, x, y, z);
        }
        return 0;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity((Block)this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    public Item func_149650_a(int meta, Random rnd, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        return meta & 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        boolean active;
        this.def.doRandomDisplayTick(world, x, y, z, random);
        int meta = world.func_72805_g(x, y, z);
        boolean bl = active = this.alwaysOn[meta & 1] || (meta & 8) != 0;
        if (active) {
            int dir = (meta >> 1 & 3) + 2;
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            if (dir == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (dir == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (dir == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (dir == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        this.def.defaultRegisterTextures(mtd);
        this.def.defaultRegisterTextureBlock(mtd);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new WCFurnaceTileEntity();
    }

    public static void updateFurnaceBlockState(boolean toActive, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        meta = toActive ? (meta |= 8) : (meta &= 7);
        world.func_72921_c(x, y, z, meta, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    @Override
    public void deliverMessage(INetHandler handler, EntityPlayer player, byte[] msg) {
        if (msg[0] == 0) {
            EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
            WCFurnaceTileEntity te = new WCFurnaceTileEntity();
            p.func_146101_a((TileEntityFurnace)te);
            p.field_71070_bA.field_75152_c = msg[1];
        }
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        WCFurnaceTileEntity te = (WCFurnaceTileEntity)par1World.func_147438_o(par2, par3, par4);
        if (te != null) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71117_bO();
            byte[] data = new byte[]{(byte)p.field_71139_cq};
            WesterosBlocksChannelHandler.sendBlockMessage((Block)this, p, (byte)0, data);
            p.field_71070_bA = new ContainerFurnace(p.field_71071_by, (TileEntityFurnace)te);
            p.field_71070_bA.field_75152_c = p.field_71139_cq;
            p.field_71070_bA.func_75132_a((ICrafting)p);
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int meta = item.func_77960_j() & 1;
        switch (facing) {
            case 0: {
                meta += 0;
                break;
            }
            case 1: {
                meta += 6;
                break;
            }
            case 2: {
                meta += 2;
                break;
            }
            case 3: {
                meta += 4;
            }
        }
        world.func_72921_c(x, y, z, meta, 2);
        if (item.func_82837_s()) {
            ((TileEntityFurnace)world.func_147438_o(x, y, z)).func_145951_a(item.func_82833_r());
        }
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(1);
            if (!def.validateMetaValues(new int[]{0, 1}, null)) {
                return null;
            }
            GameRegistry.registerTileEntity(WCFurnaceTileEntity.class, (String)def.blockName);
            return new Block[]{new WCFurnaceBlock(def)};
        }
    }
}

