/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.items.WCCuboidNSEWUDItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;

public class WCCuboidNSEWUDBlock
extends WCCuboidBlock
implements WesterosBlockLifecycle {
    private List<WesterosBlockDef.Cuboid>[] cuboids_by_meta;

    protected WCCuboidNSEWUDBlock(WesterosBlockDef def) {
        super(def);
        this.metaRotations = new WesterosBlockDef.CuboidRotation[]{WesterosBlockDef.CuboidRotation.NONE, WesterosBlockDef.CuboidRotation.ROTY90, WesterosBlockDef.CuboidRotation.ROTY180, WesterosBlockDef.CuboidRotation.ROTY270};
        this.cuboids_by_meta = new List[16];
        for (int i = 0; i < 2; ++i) {
            List<WesterosBlockDef.Cuboid> lst = def.getCuboidList(i);
            if (lst == null) continue;
            this.cuboids_by_meta[i] = lst;
            this.cuboids_by_meta[i + 2] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 4] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 6] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 8] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 10] = new ArrayList<WesterosBlockDef.Cuboid>();
            for (WesterosBlockDef.Cuboid c : lst) {
                this.cuboids_by_meta[i + 2].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY90));
                this.cuboids_by_meta[i + 4].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY180));
                this.cuboids_by_meta[i + 6].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY270));
                this.cuboids_by_meta[i + 8].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTZ90));
                this.cuboids_by_meta[i + 10].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTZ270));
            }
            this.setBoundingBoxFromCuboidList(i + 2);
            this.setBoundingBoxFromCuboidList(i + 4);
            this.setBoundingBoxFromCuboidList(i + 6);
            this.setBoundingBoxFromCuboidList(i + 8);
            this.setBoundingBoxFromCuboidList(i + 10);
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCCuboidNSEWUDItem.class);
        return true;
    }

    @Override
    public int func_149645_b() {
        return WesterosBlocks.cuboidNSEWUDRenderID;
    }

    @Override
    public int func_149692_a(int meta) {
        return meta & 1;
    }

    @Override
    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        return this.cuboids_by_meta[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getIconInternal(int side, int meta) {
        int[] sidemap = null;
        if (this.currentCuboid != null) {
            sidemap = this.currentCuboid.sideTextures;
        }
        int nside = side;
        if (sidemap != null) {
            if (nside >= sidemap.length) {
                nside = sidemap.length - 1;
            }
            nside = sidemap[nside];
        }
        return this.def.doStandardIconGet(nside, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(1);
            if (!def.validateMetaValues(new int[]{0, 1}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCCuboidNSEWUDBlock(def)};
        }
    }
}

