/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.items.WCCuboidNSEWItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class WCCuboidNSEWBlock
extends WCCuboidBlock
implements WesterosBlockLifecycle {
    private List<WesterosBlockDef.Cuboid>[] cuboids_by_meta;

    protected WCCuboidNSEWBlock(WesterosBlockDef def) {
        super(def);
        this.metaRotations = new WesterosBlockDef.CuboidRotation[]{WesterosBlockDef.CuboidRotation.NONE, WesterosBlockDef.CuboidRotation.ROTY90, WesterosBlockDef.CuboidRotation.ROTY180, WesterosBlockDef.CuboidRotation.ROTY270};
        this.cuboids_by_meta = new List[16];
        for (int i = 0; i < 4; ++i) {
            List<WesterosBlockDef.Cuboid> lst = def.getCuboidList(i);
            if (lst == null) continue;
            this.cuboids_by_meta[i] = lst;
            this.cuboids_by_meta[i + 4] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 8] = new ArrayList<WesterosBlockDef.Cuboid>();
            this.cuboids_by_meta[i + 12] = new ArrayList<WesterosBlockDef.Cuboid>();
            for (WesterosBlockDef.Cuboid c : lst) {
                this.cuboids_by_meta[i + 4].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY90));
                this.cuboids_by_meta[i + 8].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY180));
                this.cuboids_by_meta[i + 12].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY270));
            }
            this.setBoundingBoxFromCuboidList(i + 4);
            this.setBoundingBoxFromCuboidList(i + 8);
            this.setBoundingBoxFromCuboidList(i + 12);
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCCuboidNSEWItem.class);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    @Override
    public int func_149692_a(int meta) {
        return meta & 3;
    }

    @Override
    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        return this.cuboids_by_meta[meta];
    }

    @Override
    public void setActiveRenderCuboid(WesterosBlockDef.Cuboid c, RenderBlocks renderer, int meta, int index) {
        super.setActiveRenderCuboid(c, renderer, meta, index);
        int dir = meta >> 2;
        if (c != null) {
            if (dir == 1) {
                renderer.field_147867_u = 1;
                renderer.field_147865_v = 1;
            } else if (dir == 2) {
                renderer.field_147867_u = 3;
                renderer.field_147865_v = 3;
            } else if (dir == 3) {
                renderer.field_147867_u = 2;
                renderer.field_147865_v = 2;
            } else {
                renderer.field_147865_v = 0;
                renderer.field_147867_u = 0;
            }
        } else {
            renderer.field_147865_v = 0;
            renderer.field_147867_u = 0;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(3);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCCuboidNSEWBlock(def)};
        }
    }
}

