/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.WCCuboidNEBlock;
import com.westeroscraft.westerosblocks.items.WCCuboidNEStackItem;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WCCuboidNEStackBlock
extends WCCuboidNEBlock
implements WesterosBlockLifecycle {
    private boolean[] noBreakUnder = new boolean[4];

    protected WCCuboidNEStackBlock(WesterosBlockDef def) {
        super(def);
        if (def.subBlocks != null) {
            for (WesterosBlockDef.Subblock sb : def.subBlocks) {
                String[] toks;
                String type;
                if ((sb.meta & 1) != 0 || (type = def.getType(sb.meta)) == null) continue;
                for (String tok : toks = type.split(",")) {
                    if (!tok.equals("no-break-under")) continue;
                    this.noBreakUnder[sb.meta >> 1 & 3] = true;
                }
            }
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCCuboidNEStackItem.class);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 1) == 0) {
            boolean didBreak = false;
            Block above = world.func_147439_a(x, y + 1, z);
            int aboveMeta = 0;
            boolean aboveIsTop = false;
            if (above == this && (aboveMeta = world.func_72805_g(x, y + 1, z)) == (meta | 1)) {
                aboveIsTop = true;
            }
            if (!aboveIsTop) {
                world.func_147468_f(x, y, z);
                didBreak = true;
            }
            if (!this.noBreakUnder[meta >> 1 & 3] && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                world.func_147468_f(x, y, z);
                didBreak = true;
                if (aboveIsTop) {
                    world.func_147468_f(x, y + 1, z);
                }
            }
            if (didBreak && !world.field_72995_K) {
                this.func_149697_b(world, x, y, z, meta, 0);
            }
        } else {
            Block below = world.func_147439_a(x, y - 1, z);
            int belowMeta = 0;
            boolean belowIsBottom = false;
            if (below == this && (belowMeta = world.func_72805_g(x, y - 1, z)) == (meta & 0xE)) {
                belowIsBottom = true;
            }
            if (!belowIsBottom) {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public Item func_149650_a(int meta, Random rnd, int other) {
        if ((meta & 1) == 1) {
            return null;
        }
        return super.func_149650_a(meta, rnd, other);
    }

    @Override
    public int func_149692_a(int meta) {
        if ((meta & 1) == 1) {
            return 0;
        }
        return super.func_149692_a(meta);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return y >= 255 ? false : super.func_149742_c(world, x, y, z) && super.func_149742_c(world, x, y + 1, z);
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, new int[]{0, 1})) {
                return null;
            }
            if (def.subBlocks != null) {
                int matches = 0;
                for (WesterosBlockDef.Subblock sb : def.subBlocks) {
                    if ((sb.meta & 1) == 1) {
                        sb.noInventoryItem = true;
                    }
                    matches |= 1 << sb.meta;
                }
                block4: for (int i = 0; i < 4; ++i) {
                    switch (matches >> 2 * i) {
                        case 0: 
                        case 3: {
                            continue block4;
                        }
                        default: {
                            WesterosBlocks.log.severe(String.format("unmatched stacked subblocks %d in block '%s'", 2 * i, def.blockType));
                            return null;
                        }
                    }
                }
            }
            return new Block[]{new WCCuboidNEStackBlock(def)};
        }
    }
}

