/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.blocks.WCCuboidBlock;
import com.westeroscraft.westerosblocks.items.WCCuboidNEItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;

public class WCCuboidNEBlock
extends WCCuboidBlock
implements WesterosBlockLifecycle {
    private List<WesterosBlockDef.Cuboid>[] cuboids_by_meta;

    protected WCCuboidNEBlock(WesterosBlockDef def) {
        super(def);
        this.metaRotations = new WesterosBlockDef.CuboidRotation[]{WesterosBlockDef.CuboidRotation.NONE, WesterosBlockDef.CuboidRotation.ROTY90};
        this.cuboids_by_meta = new List[16];
        for (int i = 0; i < 8; ++i) {
            List<WesterosBlockDef.Cuboid> lst = def.getCuboidList(i);
            if (lst == null) continue;
            this.cuboids_by_meta[i] = lst;
            this.cuboids_by_meta[i + 8] = new ArrayList<WesterosBlockDef.Cuboid>();
            for (WesterosBlockDef.Cuboid c : lst) {
                this.cuboids_by_meta[i + 8].add(c.rotateCuboid(WesterosBlockDef.CuboidRotation.ROTY90));
            }
            this.setBoundingBoxFromCuboidList(i + 8);
        }
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, WCCuboidNEItem.class);
        return true;
    }

    @Override
    public int func_149692_a(int meta) {
        return meta & 7;
    }

    @Override
    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        return this.cuboids_by_meta[meta];
    }

    @Override
    public void setActiveRenderCuboid(WesterosBlockDef.Cuboid c, RenderBlocks renderer, int meta, int index) {
        super.setActiveRenderCuboid(c, renderer, meta, index);
        int dir = meta >> 3;
        if (c != null && dir == 1) {
            renderer.field_147867_u = 1;
            renderer.field_147865_v = 2;
        } else {
            renderer.field_147865_v = 0;
            renderer.field_147867_u = 0;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            def.setMetaMask(7);
            if (!def.validateMetaValues(new int[]{0, 1, 2, 3, 4, 5, 6, 7}, new int[]{0})) {
                return null;
            }
            return new Block[]{new WCCuboidNEBlock(def)};
        }
    }
}

