/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.blocks;

import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockFactory;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocks;
import com.westeroscraft.westerosblocks.blocks.ShiftedIcon;
import com.westeroscraft.westerosblocks.items.MultiBlockItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;

public class WCCuboidBlock
extends Block
implements WesterosBlockLifecycle,
WesterosBlockDynmapSupport {
    protected WesterosBlockDef def;
    protected WesterosBlockDef.Cuboid currentCuboid = null;
    protected int cuboidIndex = -1;
    protected IIcon[][] sideIcons = new IIcon[16][];
    protected WesterosBlockDef.CuboidRotation[] metaRotations = null;

    protected WCCuboidBlock(WesterosBlockDef def) {
        super(def.getMaterial());
        this.def = def;
        def.doStandardContructorSettings(this);
    }

    @Override
    public boolean initializeBlockDefinition() {
        this.def.doStandardInitializeActions(this);
        return true;
    }

    @Override
    public boolean registerBlockDefinition() {
        this.def.doStandardRegisterActions(this, MultiBlockItem.class);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.def.doStandardRegisterIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        boolean tmpset = false;
        if (this.cuboidIndex < 0) {
            List<WesterosBlockDef.Cuboid> clist = this.def.getCuboidList(meta);
            if (clist != null && clist.size() > 0) {
                this.currentCuboid = clist.get(0);
            }
            if (this.currentCuboid == null) {
                return null;
            }
            this.cuboidIndex = 0;
            tmpset = true;
        }
        IIcon ico = this.getIconInternal(side, meta);
        if (tmpset) {
            this.currentCuboid = null;
            this.cuboidIndex = -1;
        }
        return ico;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getIconInternal(int side, int meta) {
        if (side == 2 || side == 5) {
            List<WesterosBlockDef.Cuboid> lst;
            if (this.sideIcons[meta] == null && (lst = this.def.getCuboidList(meta)) != null) {
                this.sideIcons[meta] = new IIcon[lst.size() * 6];
            }
            if (this.sideIcons[meta][6 * this.cuboidIndex + side] != null) {
                return this.sideIcons[meta][6 * this.cuboidIndex + side];
            }
        }
        int[] sidemap = null;
        if (this.currentCuboid != null) {
            sidemap = this.currentCuboid.sideTextures;
        }
        int nside = side;
        if (sidemap != null) {
            if (nside >= sidemap.length) {
                nside = sidemap.length - 1;
            }
            nside = sidemap[nside];
        }
        IIcon ico = this.def.doStandardIconGet(nside, meta);
        if (side == 2) {
            float shft = 1.0f - this.currentCuboid.xMax - this.currentCuboid.xMin;
            if (shft != 0.0f) {
                ico = new ShiftedIcon(ico, shft);
            }
            this.sideIcons[meta][6 * this.cuboidIndex + side] = ico;
        } else if (side == 5) {
            float shft = 1.0f - this.currentCuboid.zMax - this.currentCuboid.zMin;
            if (shft != 0.0f) {
                ico = new ShiftedIcon(ico, shft);
            }
            this.sideIcons[meta][6 * this.cuboidIndex + side] = ico;
        }
        return ico;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itm, CreativeTabs tab, List list) {
        this.def.getStandardSubBlocks(this, Item.func_150891_b((Item)itm), tab, list);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        if (this.currentCuboid != null) {
            switch (side) {
                case 0: {
                    if (!(this.currentCuboid.yMin > 0.0f)) break;
                    return true;
                }
                case 1: {
                    if (!(this.currentCuboid.yMax < 1.0f)) break;
                    return true;
                }
                case 2: {
                    if (!(this.currentCuboid.zMin > 0.0f)) break;
                    return true;
                }
                case 3: {
                    if (!(this.currentCuboid.zMax < 1.0f)) break;
                    return true;
                }
                case 4: {
                    if (!(this.currentCuboid.xMin > 0.0f)) break;
                    return true;
                }
                case 5: {
                    if (!(this.currentCuboid.xMax < 1.0f)) break;
                    return true;
                }
            }
        }
        return !access.func_147439_a(x, y, z).func_149662_c();
    }

    @Override
    public WesterosBlockDef getWBDefinition() {
        return this.def;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.def.getFlammability(world, x, y, z, face);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightValue(world, x, y, z);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return this.def.getLightOpacity(this, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.def.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.def.getRenderColor(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return this.def.colorMultiplier(access, x, y, z);
    }

    public int func_149645_b() {
        return WesterosBlocks.cuboidRenderID;
    }

    public void setActiveRenderCuboid(WesterosBlockDef.Cuboid c, RenderBlocks renderer, int meta, int index) {
        this.currentCuboid = c != null ? c : null;
        this.cuboidIndex = index;
    }

    public List<WesterosBlockDef.Cuboid> getCuboidList(int meta) {
        List<WesterosBlockDef.Cuboid> rslt = this.def.getCuboidList(meta);
        if (rslt == null) {
            rslt = Collections.emptyList();
        }
        return rslt;
    }

    public void setBoundingBoxFromCuboidList(int meta) {
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(meta);
        float xmin = 100.0f;
        float ymin = 100.0f;
        float zmin = 100.0f;
        float xmax = -100.0f;
        float ymax = -100.0f;
        float zmax = -100.0f;
        for (WesterosBlockDef.Cuboid c : cl) {
            if (c.xMin < xmin) {
                xmin = c.xMin;
            }
            if (c.yMin < ymin) {
                ymin = c.yMin;
            }
            if (c.zMin < zmin) {
                zmin = c.zMin;
            }
            if (c.xMax > xmax) {
                xmax = c.xMax;
            }
            if (c.yMax > ymax) {
                ymax = c.yMax;
            }
            if (!(c.zMax > zmax)) continue;
            zmax = c.zMax;
        }
        this.def.setBoundingBox(meta, xmin, ymin, zmin, xmax, ymax, zmax);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.def.alphaRender ? 1 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rnd) {
        this.def.doRandomDisplayTick(world, x, y, z, rnd, this.metaRotations);
        super.func_149734_b(world, x, y, z, rnd);
    }

    @Override
    public void registerDynmapRenderData(ModTextureDefinition mtd) {
        ModModelDefinition md = mtd.getModelDefinition();
        WesterosBlockDef def = this.getWBDefinition();
        String blkname = def.getBlockName(0);
        def.defaultRegisterTextures(mtd);
        def.registerPatchTextureBlock(mtd, 6);
        for (int meta = 0; meta < 16; ++meta) {
            List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(meta);
            if (cl == null) continue;
            CuboidBlockModel mod = md.addCuboidModel(blkname);
            for (WesterosBlockDef.Cuboid c : cl) {
                if ("crossed".equals(c.shape)) {
                    mod.addCrossedPatches((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures[0]);
                    continue;
                }
                mod.addCuboid((double)c.xMin, (double)c.yMin, (double)c.zMin, (double)c.xMax, (double)c.yMax, (double)c.zMax, c.sideTextures);
            }
            mod.setMetaValue(meta);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(meta);
        for (WesterosBlockDef.Cuboid c : cl) {
            this.func_149676_a(c.xMin, c.yMin, c.zMin, c.xMax, c.yMax, c.zMax);
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
        this.def.setBlockBoundsBasedOnState(this, (IBlockAccess)world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        int meta = world.func_72805_g(x, y, z);
        List<WesterosBlockDef.Cuboid> cl = this.getCuboidList(meta);
        MovingObjectPosition bestpos = null;
        double bestdist = 0.0;
        for (WesterosBlockDef.Cuboid c : cl) {
            this.func_149676_a(c.xMin, c.yMin, c.zMin, c.xMax, c.yMax, c.zMax);
            MovingObjectPosition pos = super.func_149731_a(world, x, y, z, start, end);
            if (pos == null) continue;
            if (bestpos == null) {
                bestpos = pos;
                bestdist = bestpos.field_72307_f.func_72436_e(end);
                continue;
            }
            double dist = pos.field_72307_f.func_72436_e(end);
            if (!(dist > bestdist)) continue;
            bestpos = pos;
            bestdist = dist;
        }
        this.def.setBlockBoundsBasedOnState(this, (IBlockAccess)world, x, y, z);
        return bestpos;
    }

    public static class Factory
    extends WesterosBlockFactory {
        @Override
        public Block[] buildBlockClasses(WesterosBlockDef def) {
            if (!def.validateMetaValues(null, null)) {
                return null;
            }
            return new Block[]{new WCCuboidBlock(def)};
        }
    }
}

