/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks.asm;

import com.westeroscraft.westerosblocks.WesterosBlocks;
import java.lang.reflect.Method;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer,
Opcodes {
    public static Method ctmMethod = null;

    public byte[] transform(String name, String tname, byte[] bytes) {
        if (name.equals("aoi")) {
            bytes = this.transformBlockWall(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockWall")) {
            bytes = this.transformBlockWall(name, bytes, false);
        } else if (name.equals("akz")) {
            bytes = this.transformBlockFence(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockFence")) {
            bytes = this.transformBlockFence(name, bytes, false);
        } else if (name.equals("aoa")) {
            bytes = this.transformBlockPane(name, bytes, true);
        } else if (name.equals("net.minecraft.block.BlockPane")) {
            bytes = this.transformBlockPane(name, bytes, false);
        } else if (name.equals("ahm")) {
            bytes = this.transformWorldType(name, bytes, true);
        } else if (name.equals("net.minecraft.world.WorldType")) {
            bytes = this.transformWorldType(name, bytes, false);
        }
        return bytes;
    }

    private MethodNode findMethod(ClassNode cls, String methname, String methsig) {
        for (MethodNode m : cls.methods) {
            if (!m.name.equals(methname) || !m.desc.equals(methsig)) continue;
            return m;
        }
        return null;
    }

    private int findOpSequence(MethodNode meth, int[] opcodes) {
        ListIterator iter = meth.instructions.iterator();
        int index = -1;
        int seqindex = 0;
        int seqstartindex = -1;
        while (iter.hasNext()) {
            ++index;
            AbstractInsnNode node = (AbstractInsnNode)iter.next();
            if (node.getOpcode() == opcodes[seqindex]) {
                if (seqindex == 0) {
                    seqstartindex = index;
                }
                if (++seqindex != opcodes.length) continue;
                return seqstartindex;
            }
            seqindex = 0;
            seqstartindex = -1;
        }
        return -1;
    }

    private void printMethod(MethodNode meth) {
        ListIterator iter = meth.instructions.iterator();
        System.out.println("printMethod(" + meth.name + ")");
        while (iter.hasNext()) {
            AbstractInsnNode n = (AbstractInsnNode)iter.next();
            System.out.println("  " + n.getOpcode() + " (" + n.getType() + " - " + n.getClass().getName() + ")");
        }
    }

    private byte[] transformWorldType(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodSig = "";
        WesterosBlocks.log.fine("Checking class " + name);
        targetMethodName = "getCloudHeight";
        targetMethodSig = "()F";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodSig);
        if (m == null) {
            WesterosBlocks.log.warning("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        int ldx_index = this.findOpSequence(m, new int[]{18});
        if (ldx_index < 0) {
            WesterosBlocks.log.warning("Cannot patch " + targetMethodName + "() in " + name);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(11, l0);
        mv.visitVarInsn(25, 0);
        if (obfus) {
            mv.visitFieldInsn(180, "ahm", "g", "I");
        } else {
            mv.visitFieldInsn(180, "net/minecraft/world/WorldType", "worldTypeId", "I");
        }
        mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "getWorldHeight", "(I)F");
        mv.visitVarInsn(56, 1);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(12, l1);
        mv.visitVarInsn(23, 1);
        mv.visitInsn(11);
        mv.visitInsn(149);
        Label l2 = new Label();
        mv.visitJumpInsn(158, l2);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(13, l3);
        mv.visitVarInsn(23, 1);
        mv.visitInsn(174);
        mv.visitLabel(l2);
        mv.visitLineNumber(15, l2);
        mv.visitLdcInsn((Object)new Float("128.0"));
        mv.visitInsn(174);
        Label l4 = new Label();
        mv.visitLabel(l4);
        if (obfus) {
            mv.visitLocalVariable("this", "Lahm;", null, l0, l4, 0);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/world/WorldType;", null, l0, l4, 0);
        }
        mv.visitLocalVariable("rslt", "F", null, l1, l4, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        WesterosBlocks.log.fine("Method " + targetMethodName + "() of " + name + " patched!");
        return b;
    }

    private byte[] transformBlockWall(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodDesc = "";
        WesterosBlocks.log.fine("Checking class " + name);
        if (obfus) {
            targetMethodName = "e";
            targetMethodDesc = "(Lahl;III)Z";
        } else {
            targetMethodName = "canConnectWallTo";
            targetMethodDesc = "(Lnet/minecraft/world/IBlockAccess;III)Z";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodDesc);
        if (m == null) {
            WesterosBlocks.log.warning("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        int ldx_index = this.findOpSequence(m, new int[]{25, 21, 21, 21, 185});
        if (ldx_index < 0) {
            WesterosBlocks.log.warning("Cannot patch " + targetMethodName + "() in " + name);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        if (obfus) {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canConnectWallTo", "(Laji;Lahl;III)Z", false);
        } else {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canConnectWallTo", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;III)Z", false);
        }
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("this", "Laji;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lahl;", null, l0, l1, 1);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/block/Block;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lnet/minecraft/world/IBlockAccess;", null, l0, l1, 1);
        }
        mv.visitLocalVariable("x", "I", null, l0, l1, 2);
        mv.visitLocalVariable("y", "I", null, l0, l1, 3);
        mv.visitLocalVariable("z", "I", null, l0, l1, 4);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        WesterosBlocks.log.fine("Method " + targetMethodName + "() of " + name + " patched!");
        return b;
    }

    private byte[] transformBlockFence(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodDesc = "";
        WesterosBlocks.log.fine("Checking class " + name);
        if (obfus) {
            targetMethodName = "e";
            targetMethodDesc = "(Lahl;III)Z";
        } else {
            targetMethodName = "canConnectFenceTo";
            targetMethodDesc = "(Lnet/minecraft/world/IBlockAccess;III)Z";
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodDesc);
        if (m == null) {
            WesterosBlocks.log.warning("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        int ldx_index = this.findOpSequence(m, new int[]{25, 21, 21, 21, 185});
        if (ldx_index < 0) {
            WesterosBlocks.log.warning("Cannot patch " + targetMethodName + "() in " + name);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(162, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        if (obfus) {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canConnectFenceTo", "(Laji;Lahl;III)Z", false);
        } else {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canConnectFenceTo", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/IBlockAccess;III)Z", false);
        }
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("this", "Laji;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lahl;", null, l0, l1, 1);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/block/Block;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lnet/minecraft/world/IBlockAccess;", null, l0, l1, 1);
        }
        mv.visitLocalVariable("x", "I", null, l0, l1, 2);
        mv.visitLocalVariable("y", "I", null, l0, l1, 3);
        mv.visitLocalVariable("z", "I", null, l0, l1, 4);
        mv.visitMaxs(5, 5);
        mv.visitEnd();
        WesterosBlocks.log.fine("Method " + targetMethodName + "() of " + name + " patched!");
        if (obfus) {
            targetMethodName = "a";
            targetMethodDesc = "(Laji;)Z";
        } else {
            targetMethodName = "func_149825_a";
            targetMethodDesc = "(Lnet/minecraft/block/Block;)Z";
        }
        m = this.findMethod(classNode, targetMethodName, targetMethodDesc);
        if (m == null) {
            WesterosBlocks.log.warning("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        ldx_index = this.findOpSequence(m, new int[]{25, 178});
        if (ldx_index < 0) {
            WesterosBlocks.log.warning("Cannot patch " + targetMethodName + "() in " + name);
            return b;
        }
        mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(158, l0);
        mv.visitVarInsn(25, 0);
        if (obfus) {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "isFenceBlock", "(Laji;)Z", false);
        } else {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "isFenceBlock", "(Lnet/minecraft/block/Block;)Z", false);
        }
        mv.visitInsn(172);
        l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("b", "Laji;", null, l0, l1, 0);
        } else {
            mv.visitLocalVariable("b", "Lnet/minecraft/block/Block;", null, l0, l1, 0);
        }
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        WesterosBlocks.log.fine("Method " + targetMethodName + "() of " + name + " patched!");
        return b;
    }

    private byte[] transformBlockPane(String name, byte[] b, boolean obfus) {
        String targetMethodName = "";
        String targetMethodDesc = "";
        WesterosBlocks.log.fine("Checking class " + name);
        targetMethodName = "canPaneConnectTo";
        targetMethodDesc = obfus ? "(Lahl;IIILnet/minecraftforge/common/util/ForgeDirection;)Z" : "(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(b);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode m = this.findMethod(classNode, targetMethodName, targetMethodDesc);
        if (m == null) {
            WesterosBlocks.log.warning("Cannot find " + targetMethodName + "() in " + name + " for patching");
            return b;
        }
        int ldx_index = this.findOpSequence(m, new int[]{25, 25, 21, 21, 21, 185});
        if (ldx_index < 0) {
            WesterosBlocks.log.warning("Cannot patch " + targetMethodName + "() in " + name);
            return b;
        }
        MethodNode mv = m;
        m.instructions.clear();
        m.localVariables.clear();
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(162, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 3);
        mv.visitVarInsn(21, 4);
        mv.visitVarInsn(25, 5);
        if (obfus) {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canPaneConnectTo", "(Laoa;Lahl;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        } else {
            mv.visitMethodInsn(184, "com/westeroscraft/westerosblocks/asm/ClassTransformer", "canPaneConnectTo", "(Lnet/minecraft/block/BlockPane;Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/common/util/ForgeDirection;)Z", false);
        }
        mv.visitInsn(172);
        Label l1 = new Label();
        mv.visitLabel(l1);
        if (obfus) {
            mv.visitLocalVariable("this", "Laoa;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lahl;", null, l0, l1, 1);
        } else {
            mv.visitLocalVariable("this", "Lnet/minecraft/block/BlockPane;", null, l0, l1, 0);
            mv.visitLocalVariable("world", "Lnet/minecraft/world/IBlockAccess;", null, l0, l1, 1);
        }
        mv.visitLocalVariable("x", "I", null, l0, l1, 2);
        mv.visitLocalVariable("y", "I", null, l0, l1, 3);
        mv.visitLocalVariable("z", "I", null, l0, l1, 4);
        mv.visitLocalVariable("dir", "Lnet/minecraftforge/common/util/ForgeDirection;", null, l0, l1, 5);
        mv.visitMaxs(6, 6);
        mv.visitEnd();
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        b = writer.toByteArray();
        WesterosBlocks.log.fine("Method " + targetMethodName + "() of " + name + " patched!");
        return b;
    }

    public static float getWorldHeight(int wtIndex) {
        return 256.0f;
    }

    public static boolean canConnectFenceTo(Block blk, IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (blk != block && block != Blocks.field_150396_be && !(block instanceof BlockFence)) {
            Material m = block.func_149688_o();
            return block != null && m.func_76218_k() && block.func_149686_d() ? m != Material.field_151572_C : false;
        }
        return true;
    }

    public static boolean isFenceBlock(Block blk) {
        return blk instanceof BlockFence;
    }

    public static boolean canPaneConnectTo(BlockPane block, IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        Block blk = world.func_147439_a(x, y, z);
        if (block.func_150098_a(blk) || world.isSideSolid(x, y, z, dir.getOpposite(), false)) {
            return true;
        }
        return blk instanceof BlockPane && block.func_149688_o() == blk.func_149688_o();
    }

    public static boolean canConnectWallTo(Block blk, IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (blk != block && block != Blocks.field_150396_be && !(block instanceof BlockWall)) {
            Material m = block.func_149688_o();
            return block != blk && block != Blocks.field_150396_be ? (m.func_76218_k() && block.func_149686_d() ? m != Material.field_151572_C : false) : true;
        }
        return true;
    }

    public static boolean checkForCTMSupport() {
        try {
            Class<?> cls = Class.forName("com.prupe.mcpatcher.ctm.CTMUtils");
            ctmMethod = cls.getDeclaredMethod("getTile", RenderBlocks.class, Block.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, IIcon.class, Tessellator.class);
            WesterosBlocks.log.fine("CTM support found for water fix");
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ctmMethod != null;
    }
}

