/*
 * Decompiled with CFR 0.152.
 */
package com.westeroscraft.westerosblocks;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.westeroscraft.westerosblocks.DynmapSupport;
import com.westeroscraft.westerosblocks.Proxy;
import com.westeroscraft.westerosblocks.WesterosBlockConfig;
import com.westeroscraft.westerosblocks.WesterosBlockDef;
import com.westeroscraft.westerosblocks.WesterosBlockDynmapSupport;
import com.westeroscraft.westerosblocks.WesterosBlockLifecycle;
import com.westeroscraft.westerosblocks.WesterosBlocksCreativeTab;
import com.westeroscraft.westerosblocks.asm.ClassTransformer;
import com.westeroscraft.westerosblocks.network.PacketHandler;
import com.westeroscraft.westerosblocks.network.WesterosBlocksChannelHandler;
import com.westeroscraft.westerosblocks.render.WCCuboidNSEWUDRenderer;
import com.westeroscraft.westerosblocks.render.WCCuboidRenderer;
import com.westeroscraft.westerosblocks.render.WCFenceRenderer;
import com.westeroscraft.westerosblocks.render.WCFluidCTMRenderer;
import com.westeroscraft.westerosblocks.render.WCHalfDoorRenderer;
import com.westeroscraft.westerosblocks.render.WCLadderRenderer;
import com.westeroscraft.westerosblocks.render.WCStairRenderer;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="WesterosBlocks", name="WesterosBlocks", version="2.0.1-alpha-2-248")
public class WesterosBlocks {
    public static Logger log = Logger.getLogger("WesterosBlocks");
    @Mod.Instance(value="WesterosBlocks")
    public static WesterosBlocks instance;
    @SidedProxy(clientSide="com.westeroscraft.westerosblocks.ClientProxy", serverSide="com.westeroscraft.westerosblocks.Proxy")
    public static Proxy proxy;
    public DynmapSupport dynmap = null;
    public static Block[] customBlocks;
    public static HashMap<String, Block> customBlocksByName;
    public static int fenceRenderID;
    public static int ladderRenderID;
    public static int halfdoorRenderID;
    public static int cuboidRenderID;
    public static int cuboidNSEWUDRenderID;
    public static int stairRenderID;
    public static int fluidCTMRenderID;
    public boolean useFixedStairs = false;
    public boolean useFixedPressurePlate = false;
    public boolean useWaterCTMFix = false;
    public boolean snowInTaiga = false;
    public static BitSet slabStyleLightingBlocks;
    public static WesterosBlockConfig customConfig;
    public static WesterosBlockDef[] customBlockDefs;
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    public boolean good_init = false;

    public static Block findBlockByName(String blkname) {
        Block blk = customBlocksByName.get(blkname);
        if (blk != null) {
            return blk;
        }
        try {
            return Block.func_149684_b((String)blkname);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void crash(Exception x, String msg) {
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)x, (String)msg);
        throw new ReportedException(crashreport);
    }

    public static void crash(String msg) {
        WesterosBlocks.crash(new Exception(), msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        WesterosBlockDef.initialize();
        WesterosBlocksCreativeTab.init();
        InputStream in = this.getClass().getResourceAsStream("/WesterosBlocks.json");
        if (in == null) {
            WesterosBlocks.crash("WesterosBlocks couldn't find its block definition resource");
            return;
        }
        InputStreamReader rdr = new InputStreamReader(in);
        Gson gson = new Gson();
        try {
            customConfig = (WesterosBlockConfig)gson.fromJson((Reader)rdr, WesterosBlockConfig.class);
            customBlockDefs = WesterosBlocks.customConfig.blocks;
        }
        catch (JsonSyntaxException iox) {
            WesterosBlocks.crash((Exception)((Object)iox), "WesterosBlocks couldn't parse its block definition");
            return;
        }
        catch (JsonIOException iox) {
            WesterosBlocks.crash((Exception)((Object)iox), "WesterosBlocks couldn't read its block definition");
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
        }
        log.info("Loaded " + customBlockDefs.length + " block definitions");
        if (!WesterosBlockDef.sanityCheck(customBlockDefs)) {
            WesterosBlocks.crash("WesterosBlocks.json failed sanity check");
            return;
        }
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            this.useFixedStairs = cfg.get("Settings", "useFixedStairs", true).getBoolean(true);
            this.useFixedPressurePlate = cfg.get("Settings", "useFixedPressurePlate", true).getBoolean(true);
            this.useWaterCTMFix = cfg.get("Settings", "useWaterCTMFix", true).getBoolean(true);
            this.snowInTaiga = cfg.get("Settings", "snowInTaiga", true).getBoolean(true);
            this.good_init = true;
        }
        catch (Exception e) {
            WesterosBlocks.crash(e, "WesterosBlocks couldn't load its configuration");
        }
        finally {
            cfg.save();
        }
        slabStyleLightingBlocks.clear();
        if (this.snowInTaiga) {
            BiomeGenBase.field_76768_g.func_76742_b().func_76732_a(-0.5f, 0.4f);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        int i;
        if (!this.good_init) {
            WesterosBlocks.crash("preInit failed - aborting load()");
            return;
        }
        fenceRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCFenceRenderer());
        ladderRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCLadderRenderer());
        cuboidRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCCuboidRenderer());
        halfdoorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCHalfDoorRenderer());
        cuboidNSEWUDRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCCuboidNSEWUDRenderer());
        stairRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCStairRenderer());
        if (this.useWaterCTMFix && ClassTransformer.checkForCTMSupport()) {
            fluidCTMRenderID = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new WCFluidCTMRenderer());
        } else {
            this.useWaterCTMFix = false;
            fluidCTMRenderID = 4;
        }
        proxy.initRenderRegistry();
        ArrayList<Block> blklist = new ArrayList<Block>();
        customBlocksByName = new HashMap();
        for (i = 0; i < customBlockDefs.length; ++i) {
            if (customBlockDefs[i] == null) continue;
            Block[] blks = customBlockDefs[i].createBlocks();
            if (blks != null) {
                for (int j = 0; j < blks.length; ++j) {
                    Block blk = blks[j];
                    blklist.add(blk);
                    customBlocksByName.put(customBlockDefs[i].getBlockName(j), blk);
                }
                continue;
            }
            WesterosBlocks.crash("Invalid block definition for " + WesterosBlocks.customBlockDefs[i].blockName + " - aborted during load()");
            return;
        }
        customBlocks = blklist.toArray(new Block[blklist.size()]);
        for (i = 0; i < customBlocks.length; ++i) {
            if (!(customBlocks[i] instanceof WesterosBlockLifecycle)) continue;
            ((WesterosBlockLifecycle)customBlocks[i]).initializeBlockDefinition();
        }
        for (i = 0; i < customBlocks.length; ++i) {
            if (!(customBlocks[i] instanceof WesterosBlockLifecycle)) continue;
            ((WesterosBlockLifecycle)customBlocks[i]).registerBlockDefinition();
        }
        channels = NetworkRegistry.INSTANCE.newChannel("WesterosBlocks", new ChannelHandler[]{new WesterosBlocksChannelHandler(), new PacketHandler()});
        try {
            this.handleDynmap();
        }
        catch (NoClassDefFoundError x) {
            log.info("Dynmap Mod Support API not found");
            this.dynmap = null;
        }
    }

    private void handleDynmap() {
        this.dynmap = new DynmapSupport("WesterosBlocks", "2.0.1-alpha-2-248");
        for (int i = 0; i < customBlocks.length; ++i) {
            if (customBlocks[i] instanceof WesterosBlockDynmapSupport) {
                ((WesterosBlockDynmapSupport)customBlocks[i]).registerDynmapRenderData(this.dynmap.getTextureDef());
                continue;
            }
            log.info("No Dynmap render support for blockID=" + customBlocks[i].func_149739_a());
        }
        this.dynmap.complete();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
    }

    static {
        slabStyleLightingBlocks = new BitSet();
    }
}

