/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.nbt;

import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class ForgeMultipart {
    private static boolean enabled = false;
    private static boolean client = false;
    private static Method methodCreatePart;
    private static Method methodLoad;
    private static Method methodOnPartChanged;
    private static Object instanceMultipartGenerator$;
    private static Method methodGenerateCompositeTile;
    private static Method methodLoadParts;
    private static Method methodCreateFromNBT;

    public static void init() {
        enabled = Loader.isModLoaded((String)"ForgeMultipart");
        client = FMLCommonHandler.instance().getSide().isClient();
        if (enabled) {
            try {
                ClassLoader classLoader = ForgeMultipart.class.getClassLoader();
                Class classMultiPartRegistry = ReflectionHelper.getClass((ClassLoader)classLoader, (String[])new String[]{"codechicken.multipart.MultiPartRegistry"});
                methodCreatePart = ReflectionHelper.findMethod((Class)classMultiPartRegistry, null, (String[])new String[]{"createPart"}, (Class[])new Class[]{String.class, Boolean.TYPE});
                Class classTMultiPart = ReflectionHelper.getClass((ClassLoader)classLoader, (String[])new String[]{"codechicken.multipart.TMultiPart"});
                methodLoad = ReflectionHelper.findMethod((Class)classTMultiPart, null, (String[])new String[]{"load"}, (Class[])new Class[]{NBTTagCompound.class});
                methodOnPartChanged = ReflectionHelper.findMethod((Class)classTMultiPart, null, (String[])new String[]{"onPartChanged"}, (Class[])new Class[]{classTMultiPart});
                Class classMultipartGenerator$ = ReflectionHelper.getClass((ClassLoader)classLoader, (String[])new String[]{"codechicken.multipart.MultipartGenerator$"});
                Field fieldMultipartGenerator$module$ = ReflectionHelper.findField((Class)classMultipartGenerator$, (String[])new String[]{"MODULE$"});
                instanceMultipartGenerator$ = fieldMultipartGenerator$module$.get(classMultipartGenerator$);
                methodGenerateCompositeTile = ReflectionHelper.findMethod((Class)classMultipartGenerator$, null, (String[])new String[]{"generateCompositeTile"}, (Class[])new Class[]{TileEntity.class, Iterable.class, Boolean.TYPE});
                Class classTileMultipart = ReflectionHelper.getClass((ClassLoader)classLoader, (String[])new String[]{"codechicken.multipart.TileMultipart"});
                methodLoadParts = ReflectionHelper.findMethod((Class)classTileMultipart, null, (String[])new String[]{"loadParts"}, (Class[])new Class[]{Iterable.class});
                methodCreateFromNBT = ReflectionHelper.findMethod((Class)classTileMultipart, null, (String[])new String[]{"createFromNBT"}, (Class[])new Class[]{NBTTagCompound.class});
            }
            catch (Exception e) {
                Reference.logger.error("Something went wrong, disabling FMP integration.", (Throwable)e);
                enabled = false;
            }
        }
    }

    public static TileEntity createFromNBT(NBTTagCompound tileEntityCompound) {
        return ForgeMultipart.createFromNBT(tileEntityCompound, client);
    }

    public static TileEntity createFromNBT(NBTTagCompound tileEntityCompound, boolean client) {
        if (!enabled) {
            return null;
        }
        try {
            if (client) {
                return ForgeMultipart.createFromNBTClient(tileEntityCompound);
            }
            return ForgeMultipart.createFromNBTServer(tileEntityCompound);
        }
        catch (Exception e) {
            Reference.logger.error("Something went wrong!", (Throwable)e);
            return null;
        }
    }

    private static TileEntity createFromNBTClient(NBTTagCompound tileEntityCompound) throws ReflectiveOperationException {
        NBTTagList partList = tileEntityCompound.func_150295_c("parts", 10);
        ArrayList<Object> parts = new ArrayList<Object>();
        boolean client = true;
        for (int i = 0; i < partList.func_74745_c(); ++i) {
            NBTTagCompound partTag = partList.func_150305_b(i);
            String string = partTag.func_74779_i("id");
            Object part = ForgeMultipart.createPart(string, true);
            if (part == null) continue;
            ForgeMultipart.load(part, partTag);
            parts.add(part);
        }
        if (parts.size() != partList.func_74745_c()) {
            Reference.logger.info("Mismatched part size (got {}, expected {})", new Object[]{parts.size(), partList.func_74745_c()});
            return null;
        }
        if (parts.size() == 0) {
            return null;
        }
        TileEntity tileEntity = ForgeMultipart.generateCompositeTile(null, parts, true);
        tileEntity.func_145839_a(tileEntityCompound);
        ForgeMultipart.loadParts(tileEntity, parts);
        for (Object e : parts) {
            ForgeMultipart.onPartChanged(e, e);
        }
        return tileEntity;
    }

    private static TileEntity createFromNBTServer(NBTTagCompound tileEntityCompound) {
        try {
            return (TileEntity)methodCreateFromNBT.invoke(null, tileEntityCompound);
        }
        catch (Exception e) {
            Reference.logger.warn("Something went wrong!", (Throwable)e);
            return null;
        }
    }

    private static Object createPart(String partID, boolean client) throws ReflectiveOperationException {
        return methodCreatePart.invoke(null, partID, client);
    }

    private static Object load(Object part, NBTTagCompound partTag) throws ReflectiveOperationException {
        return methodLoad.invoke(part, partTag);
    }

    private static Object onPartChanged(Object part, Object part2) throws ReflectiveOperationException {
        return methodOnPartChanged.invoke(part, part2);
    }

    private static TileEntity generateCompositeTile(TileEntity tileEntity, List<Object> parts, boolean client) throws ReflectiveOperationException {
        return (TileEntity)methodGenerateCompositeTile.invoke(instanceMultipartGenerator$, tileEntity, JavaConversions.collectionAsScalaIterable(parts), client);
    }

    private static void loadParts(TileEntity tileEntity, List<Object> parts) throws ReflectiveOperationException {
        methodLoadParts.invoke((Object)tileEntity, JavaConversions.collectionAsScalaIterable(parts));
    }
}

