/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.world;

import com.github.lunatrius.core.util.vector.Vector3f;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.ChunkProviderSchematic;
import com.github.lunatrius.schematica.world.storage.SaveHandlerSchematic;
import com.github.lunatrius.schematica.world.storage.Schematic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicWorld
extends World {
    private static final WorldSettings WORLD_SETTINGS = new WorldSettings(0L, WorldSettings.GameType.CREATIVE, false, false, WorldType.field_77138_c);
    public static final ItemStack DEFAULT_ICON = new ItemStack((Block)Blocks.field_150349_c);
    private ISchematic schematic;
    public final Vector3i position = new Vector3i();
    public boolean isRendering;
    public boolean isRenderingLayer;
    public int renderingLayer;

    public SchematicWorld(ISchematic schematic) {
        super((ISaveHandler)new SaveHandlerSchematic(), "Schematica", WORLD_SETTINGS, null, null);
        this.schematic = schematic;
        for (TileEntity tileEntity : schematic.getTileEntities()) {
            this.initializeTileEntity(tileEntity);
        }
        this.isRendering = false;
        this.isRenderingLayer = false;
        this.renderingLayer = 0;
    }

    public Block func_147439_a(int x, int y, int z) {
        if (this.isRenderingLayer && this.renderingLayer != y) {
            return Blocks.field_150350_a;
        }
        return this.schematic.getBlock(x, y, z);
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int metadata, int flags) {
        return this.schematic.setBlock(x, y, z, block, metadata);
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return this.schematic.getTileEntity(x, y, z);
    }

    public void func_147455_a(int x, int y, int z, TileEntity tileEntity) {
        this.schematic.setTileEntity(x, y, z, tileEntity);
        this.initializeTileEntity(tileEntity);
    }

    public void func_147475_p(int x, int y, int z) {
        this.schematic.removeTileEntity(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72925_a(EnumSkyBlock skyBlock, int x, int y, int z) {
        return 15;
    }

    public float func_72801_o(int x, int y, int z) {
        return 1.0f;
    }

    public int func_72805_g(int x, int y, int z) {
        return this.schematic.getBlockMetadata(x, y, z);
    }

    public boolean func_147445_c(int x, int y, int z, boolean _default) {
        return this.func_147439_a(x, y, z).func_149721_r();
    }

    protected int func_152379_p() {
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int x, int z) {
        return BiomeGenBase.field_76782_w;
    }

    public int getWidth() {
        return this.schematic.getWidth();
    }

    public int getLength() {
        return this.schematic.getLength();
    }

    public int func_72800_K() {
        return this.schematic.getHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderSchematic(this);
    }

    public Entity func_73045_a(int id) {
        return null;
    }

    public boolean func_72899_e(int x, int y, int z) {
        return false;
    }

    public boolean func_72921_c(int x, int y, int z, int metadata, int flag) {
        return this.schematic.setBlockMetadata(x, y, z, metadata);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
        return this.isSideSolid(x, y, z, side, false);
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public void initializeTileEntity(TileEntity tileEntity) {
        tileEntity.func_145834_a((World)this);
        tileEntity.func_145838_q();
        try {
            tileEntity.func_145829_t();
        }
        catch (Exception e) {
            Reference.logger.error("TileEntity validation for {} failed!", new Object[]{tileEntity.getClass(), e});
        }
    }

    public void setIcon(ItemStack icon) {
        this.schematic.setIcon(icon);
    }

    public ItemStack getIcon() {
        return this.schematic.getIcon();
    }

    public List<TileEntity> getTileEntities() {
        return this.schematic.getTileEntities();
    }

    public boolean toggleRendering() {
        this.isRendering = !this.isRendering;
        return this.isRendering;
    }

    public void refreshChests() {
        for (TileEntity tileEntity : this.schematic.getTileEntities()) {
            if (!(tileEntity instanceof TileEntityChest)) continue;
            TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
            tileEntityChest.field_145984_a = false;
            tileEntityChest.func_145979_i();
        }
    }

    public void flip() {
    }

    public void rotate() {
        ItemStack icon = this.schematic.getIcon();
        int width = this.schematic.getWidth();
        int height = this.schematic.getHeight();
        int length = this.schematic.getLength();
        Schematic schematicRotated = new Schematic(icon, length, height, width);
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < length; ++z) {
                for (int x = 0; x < width; ++x) {
                    try {
                        this.func_147439_a(x, y, length - 1 - z).rotateBlock((World)this, x, y, length - 1 - z, ForgeDirection.UP);
                    }
                    catch (Exception e) {
                        Reference.logger.debug("Failed to rotate block!", (Throwable)e);
                    }
                    Block block = this.func_147439_a(x, y, length - 1 - z);
                    int metadata = this.func_72805_g(x, y, length - 1 - z);
                    schematicRotated.setBlock(z, y, x, block, metadata);
                }
            }
        }
        for (TileEntity tileEntity : this.schematic.getTileEntities()) {
            int coord = tileEntity.field_145849_e;
            tileEntity.field_145849_e = tileEntity.field_145851_c;
            tileEntity.field_145851_c = length - 1 - coord;
            tileEntity.field_145847_g = schematicRotated.getBlockMetadata(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            if (tileEntity instanceof TileEntitySkull && tileEntity.field_145847_g == 1) {
                TileEntitySkull skullTileEntity = (TileEntitySkull)tileEntity;
                skullTileEntity.func_145903_a(skullTileEntity.func_145906_b() + 12 & 0xF);
            }
            schematicRotated.setTileEntity(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity);
        }
        this.schematic = schematicRotated;
        this.refreshChests();
    }

    public Vector3f dimensions() {
        return new Vector3f((float)this.schematic.getWidth(), (float)this.schematic.getHeight(), (float)this.schematic.getLength());
    }

    public String getDebugDimensions() {
        return "WHL: " + this.getWidth() + " / " + this.func_72800_K() + " / " + this.getLength();
    }
}

